#!/bin/bash

# Save the start time.
start_time=$(date +%s)

SOURCE_FOLDER="KITS"
DEST_BASE_FOLDER="SONGS"
TOTAL_FOLDERS=$((4 * 10 * 16))
FOLDERS_COPIED=0
PROGRESS_BAR_LENGTH=50

# Function to draw the progress bar.
draw_progress_bar() {
    local _progress=$1
    local _total=$2
    local _filled=$(( (_progress * PROGRESS_BAR_LENGTH) / _total ))
    local _unfilled=$(( PROGRESS_BAR_LENGTH - _filled ))
    local _filled_bar=$(printf '%0.s#' $(seq 1 $_filled))
    local _unfilled_bar=$(printf '%0.s-' $(seq 1 $_unfilled))
    local _percentage=$(( (_progress * 100) / _total ))
    echo -ne "\rProgress: [${_filled_bar}${_unfilled_bar}] $_percentage%"
}

echo "Starting the copy operation..."

# Loop through BANK1 to BANK10 for SONGS folder
for BANK_NUM in {1..10}; do
    # Loop through SONG1 to SONG16 in each BANK
    for SONG_NUM in {1..16}; do
        # Create a KITS folder in each SONG directory
        mkdir -p "${DEST_BASE_FOLDER}/BANK${BANK_NUM}/SONG${SONG_NUM}/KITS"
        # Loop through BANK1 to BANK4 in KITS folder
        for KIT_BANK_NUM in {1..4}; do
            SOURCE_SUBFOLDER="${SOURCE_FOLDER}/BANK${KIT_BANK_NUM}"
            DEST_FOLDER="${DEST_BASE_FOLDER}/BANK${BANK_NUM}/SONG${SONG_NUM}/KITS/BANK${KIT_BANK_NUM}"

            # Check if the source subfolder exists
            if [ -d "${SOURCE_SUBFOLDER}" ]; then
                # Copy the KITS BANK folder to the destination
                cp -R "${SOURCE_SUBFOLDER}" "${DEST_FOLDER}"
                ((FOLDERS_COPIED++))
                draw_progress_bar $FOLDERS_COPIED $TOTAL_FOLDERS
            else
                echo "Source subfolder ${SOURCE_SUBFOLDER} does not exist."
            fi
        done
    done
done

echo -ne "\n" # Move to a new line after the progress bar

# Calculate elapsed time
end_time=$(date +%s)
elapsed=$((end_time - start_time))
echo "Copy operation completed."
echo "Elapsed Time: $((elapsed / 60)) minute(s) and $((elapsed % 60)) second(s)."
echo "THANKS, HAVE FUN"
