@echo off
setlocal enabledelayedexpansion

set "SOURCE_FOLDER=KITS"
set "DEST_BASE_FOLDER=SONGS"
set /a TOTAL_FOLDERS=4*10*16
set /a FOLDERS_COPIED=0

echo Starting copy operation...

for /L %%B in (1,1,10) do (
    for /L %%S in (1,1,16) do (
        for /L %%K in (1,1,4) do (
            set "SOURCE_SUBFOLDER=!SOURCE_FOLDER!\BANK%%K"
            set "DEST_FOLDER=!DEST_BASE_FOLDER!\BANK%%B\SONG%%S\!SOURCE_SUBFOLDER!"
            xcopy "!SOURCE_SUBFOLDER!" "!DEST_FOLDER!" /E /I /Y >nul
            if errorlevel 1 (
                echo Error occurred during copying to !DEST_FOLDER!
            ) else (
                set /a FOLDERS_COPIED+=1
                call :show_progress !FOLDERS_COPIED! %TOTAL_FOLDERS%
            )
        )
    )
)

echo Copy operation completed.
echo THANKS, HAVE FUN

pause
goto :eof

:show_progress
set /a _progress=100*%1/%2
set /a _ticks=_progress/2
set "_bar=["
for /L %%i in (1,1,%_ticks%) do set "_bar=!_bar!#"
set /a _spaces=50-%_ticks%
for /L %%i in (1,1,%_spaces%) do set "_bar=!_bar!-"
set "_bar=!_bar!] %_progress%%%"
echo %_bar%
goto :eof
